
-- some common method, it does not depend on the other script files

function PxGrabRotations n =
(
	-- we might consider adding more slidertime samples later when our algo is more intelligent
	local quatlist = #()  
	for k in n.rotation.controller.keys do
	(
		slidertime = k.time
		append quatlist n.controller.rotation
	)
	slidertime = animationRange.start
	quatlist
)

function PxGrabPositions n =
(
	-- we might consider adding more slidertime samples later when our algo is more intelligent
	local poslist = #()  
	for k in n.position.controller.keys do
	(
		slidertime = k.time
		append poslist n.controller.position
	)
	slidertime = animationRange.start
	poslist
)

function PxCalcJointLimits n =
(
	quatlist = PxGrabRotations n
	if(quatlist.count <2) then
	(
		if PHYSX_AUTODESK_VER!=undefined then format "MassFX Warning: not enough keys to extract any useful info!\n" else
			format "PhysX Warning: not enough keys to extract any useful info!\n"
		[0,-45,45]; 
	)
	else
	(
		local r = quatlist[2] / quatlist[1]
		axis = r.axis
		cp  = cross r.axis [0,0,1] 
		cpb = cross r.axis [0,1,0] 
		if(length(cpb)>length(cp)) then
		(
			cp = cpb
		)
		nrml = normalize ( cp )
		
		slidertime = animationRange.start;
		--axis = getpoint3prop n "pmljointaxis" 
		--nrml = getpoint3prop n "pmljointnrml"
		--format "axis = %, normal = %\n" axis nrml
		na = nrml
		nloc = nrml * (conjugate(quatlist[1]) as Matrix3) 
		local limithigh=0
		local limitlow=0
		local theta=0;
		local q
		for q in quatlist do
		(
			nb = nloc *(q as Matrix3) 
			dp = dot na nb 
			if(dp> 1.0) then dp =  1.0 ;
			if(dp<-1.0) then dp = -1.0 ;
			delta = acos(dp)
			cp = cross na nb ;
			if((dot axis cp) <0) then
			(
				delta = -delta;
			)
			theta = theta + delta
			if(theta > limithigh) then 
			(
				limithigh = theta
			)
			if(theta < limitlow) then 
			(
				limitlow = theta
			)
			na = nb;
		)
		
		--format "axis = %, normal = %, limitlow = %, limithigh = %\n" axis nrml limitlow limithigh
		slidertime = animationRange.start;
		if(limithigh-limitlow > 315) then
		(
			[0,limitlow,limithigh]
		)
		else [1,limitlow,limithigh]
	)
)

-- Sorted set of items, supports union and intersection operations
struct SortedArray_Struct
(
	itemArray = #(),
	
	fn DefaultComparator a b =
	(
		if a > b then 1
		else if a < b then -1
		else 0
	),
	comparator = DefaultComparator,	
	
	fn FindIndex item findExisting:true =
	(	-- Binary search.  Returns index where item should be inserted, or existing item if findExisting==true
		local len = itemArray.count
		local lo = 1, hi = len, cur = 1, exists = false
		while lo<=hi do
		(
			cur = (lo + ((hi-lo)/2))
			local res = Comparator item itemArray[cur]
			if res==0 then ( exists = true; lo=(hi+1) ) -- force loop to break
			else if res<0 then hi=(cur-1)
		else if res>0 then lo=cur=(cur+1)
		)
		if (findExisting) and (not exists) then 0
		else cur
	),
	fn AddItem item = 
	(
		local index = FindIndex item findExisting:false
		insertItem item itemArray index
	),
	fn SetUnion itemArrayInput =
	(
		if (isKindOf itemArrayInput SortedArray_Struct) then itemArrayInput = itemArrayInput.itemArray
		for item in itemArrayInput do AddItem item
	),
	fn SetIntersection itemArrayInput =
	(
		b = #{} -- BitArray, all values initially false
		if (isKindOf itemArrayInput SortedArray_Struct) then itemArrayInput = itemArrayInput.itemArray
		for item in itemArrayInput do
		(
			local index = FindIndex item findExisting:false
			if (itemArray[index]==item) then b[index] = true
		)
		for index = itemArray.count to 1 by -1 do
		(
			if not b[index] then deleteItem itemArray index
		)
	),

	fn Init itemArrayInput comparator:undefined =
	(
		itemArray = #()
		if (comparator!=undefined) then this.comparator = comparator
		SetUnion itemArrayInput
	)
)
